#pragma once

static const char INDEX_HTML[] = R"HTML(
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<!-- Qt WebChannel -->
<script src="qrc:///qtwebchannel/qwebchannel.js"></script>

<!-- Default Theme -->
<link rel="stylesheet" data-theme="default" href="qrc:/css/style_neu.css">
<link rel="stylesheet" href="qrc:/js/ed/ui/trumbowyg.min.css">

<!-- Core JS -->
<script src="qrc:/js/jquery/jquery-3.7.1.min.js"></script>
<script src="qrc:/js/ed/trumbowyg.min.js"></script>
<script src="qrc:/js/ed/plugins/base64/trumbowyg.base64.js"></script>
</head>
<body>
<script>
(function initWebChannelWhenReady() {
    if (!window.qt || !qt.webChannelTransport) {
        setTimeout(initWebChannelWhenReady, 25);
        return;
    }

    new QWebChannel(qt.webChannelTransport, function (channel) {
        // 🔥 Plugin-APIs global verfügbar machen
        Object.assign(window, channel.objects);

        console.log("✅ WebChannel ready:", Object.keys(channel.objects));

        // ✅ HIER kommen die zwei Zeilen rein
        window.__webchannelReady = true;
        document.dispatchEvent(new Event('webchannel-ready'));

        console.log(
            "Plugins:",
            Object.keys(window).filter(
                k => typeof window[k]?.ping === 'function'
            )
        );
    });
})();
</script>
<!-- Settings button links -->
<div id="settingsButton">
    <img src="icons/Design/menu-line.svg" class="f_invert">
</div>

<!-- Uhr bleibt zentriert -->
<div id="datetimebar"></div>


<!-- Screenshot / Screenrecorder UI -->
<div id="capturePanel" class="panel hidden">
    <div class="panel-section">
        <div class="panel-title">
			<img class="f_invert" src="icons/Design/screenshot-2-fill.svg"> Screenshot
			<img class="open-folder" style="filter: invert(1);" src="icons/Document/folder-open-line.svg" title="Show screenshots" onclick=" backend.screenshotPath().then(path => { backend.openFolder(path); backend.toggleFromJS();});">

		</div>


        <button class="btn" data-action="shot-area">Screen Area</button>
        <button class="btn" data-action="shot-screen">Whole screen</button>

        <div class="delay-block">
            <label>Delay before start</label>
            <div class="delay-buttons white">
                <button class="delay" data-delay="3">3s</button>
				<button class="delay" data-delay="5">5s</button>
				<button class="delay" data-delay="10">10s</button>
            </div>
        </div>
    </div>

    <div class="panel-section">
        <div class="panel-title">
			<img class="f_invert" src="icons/Media/record-circle-line.svg"> Record Video
			<img class="open-folder" style="filter: invert(1);" src="icons/Document/folder-open-line.svg" title="Show screenrecordings" onclick=" backend.recordPath().then(path => { backend.openFolder(path); backend.toggleFromJS(); });">
		</div>

		
        <button class="btn" data-action="rec-area">Screen Area</button>
        <button class="btn" data-action="rec-screen">Whole screen</button>
		<label class="audio-toggle">
			<input type="checkbox" id="captureAudio">
			<span>Record audio</span>
		</label>
        <div class="delay-block">
            <label>Delay before start</label>
            <div class="delay-buttons white">
                <button class="delay" data-delay="3">3s</button>
				<button class="delay" data-delay="5">5s</button>
				<button class="delay" data-delay="10">10s</button>
            </div>
        </div>
    </div>
    <button id="stopRecordingBtn" class="btn stop-btn versteckt">Stop recording</button>
</div>

<!-- Panel oben UI -->
<div id="calendar" class="hidden"></div>
<div id="topcontrols">
	<div id="noteIcon">📒</div>
    <div id="volControls">
        <div id="volBarContainer">
			<div id="volBar"></div>
		</div>
		<span id="volMute">🔇</span>
    </div>
    <div id="exitHypr">⏻</div>
</div>

<div id="eventDialog" class="hidden">
    <div class="event-inner">
        <h2>Event</h2>

        <label>Title:</label>
        <input id="eventTitle">

        <label><input type="checkbox" id="eventAllDay" checked> All day</label>

        <div id="eventTimes">
            <label>Start:</label>
            <input id="eventStart" type="time">
            <label>End:</label>
            <input id="eventEnd" type="time">
        </div>

        <label>
            <input type="checkbox" id="eventRepeat"> Repeat yearly
        </label>

        <button id="eventSave">Save</button>
        <button id="eventDelete">Delete</button>
        <button id="eventCancel">Cancel</button>
    </div>
</div>


<!-- Default: Das App Grid: Hauptfunktion des Launchers -->
<div id="appAddBtn">+</div>
<div id="appgrid"></div>

<!-- Musiksuche -->
<div id="musicPanel" class="hidden">
    <input id="musicInput" placeholder="Song-Search…" autocomplete="off">
    <div id="musicResults" tabindex="-1"></div>
</div>

<!-- Videosuche -->
<div id="videoPanel" class="hidden">
    <input id="videoInput" placeholder="Video-Search…" autocomplete="off">
    <div id="videoResults" tabindex="-1"></div>
</div>


<!-- System-Monitor UI -->
<div id="sysmon" class="hidden">
    <div id="sysmon-frame">
        <div class="title">SYSTEM STATUS</div>
        <div class="metric">
            <span>CPU</span>
            <div class="bar"><div id="cpuBar"></div></div>
            <div id="cpuVal" class="val">0%</div>
        </div>
		<div class="metric">
			<span>CPU TEMP</span>
			<div class="bar"><div id="tempBar"></div></div>
			<div id="tempVal" class="val">0°C</div>
		</div>
        <div class="metric">
            <span>RAM</span>
            <div class="bar"><div id="ramBar"></div></div>
            <div id="ramVal" class="val">0%</div>
        </div>
    </div>
</div>


<!-- Notizen UI -->
<div id="trumbowyg-icons" style="display:none;">
	<svg xmlns="http://www.w3.org/2000/svg">
		<symbol id="trumbowyg-blockquote" viewBox="0 0 72 72"><path d="M21.3 31.9h-.6c.8-1.2 1.9-2.2 3.4-3.2 2.1-1.4 5-2.7 9.2-3.3l-1.4-8.9c-4.7.7-8.5 2.1-11.7 4-2.4 1.4-4.3 3.1-5.8 4.9-2.3 2.7-3.7 5.7-4.5 8.5-.8 2.8-1 5.4-1 7.5 0 2.3.3 4 .4 4.8 0 .1.1.3.1.4 1.2 5.4 6.1 9.5 11.9 9.5 6.7 0 12.2-5.4 12.2-12.2s-5.5-12-12.2-12zm28.2 0h-.6c.8-1.2 1.9-2.2 3.4-3.2 2.1-1.4 5-2.7 9.2-3.3l-1.4-8.9c-4.7.7-8.5 2.1-11.7 4-2.4 1.4-4.3 3.1-5.8 4.9-2.3 2.7-3.7 5.7-4.5 8.5-.8 2.8-1 5.4-1 7.5 0 2.3.3 4 .4 4.8 0 .1.1.3.1.4 1.2 5.4 6.1 9.5 11.9 9.5 6.7 0 12.2-5.4 12.2-12.2s-5.5-12-12.2-12z"/></symbol><symbol id="trumbowyg-bold" viewBox="0 0 72 72"><path d="M51.1 37.8c-1.1-1.4-2.5-2.5-4.2-3.3 1.2-.8 2.1-1.8 2.8-3 1-1.6 1.5-3.5 1.5-5.3 0-2-.6-4-1.7-5.8-1.1-1.8-2.8-3.2-4.8-4.1-2-.9-4.6-1.3-7.8-1.3h-16v42h16.3c2.6 0 4.8-.2 6.7-.7 1.9-.5 3.4-1.2 4.7-2.1 1.3-1 2.4-2.4 3.2-4.1.9-1.7 1.3-3.6 1.3-5.7.2-2.5-.5-4.7-2-6.6zM40.8 50.2c-.6.1-1.8.2-3.4.2h-9V38.5h8.3c2.5 0 4.4.2 5.6.6 1.2.4 2 1 2.7 2 .6.9 1 2 1 3.3 0 1.1-.2 2.1-.7 2.9-.5.9-1 1.5-1.7 1.9-.8.4-1.7.8-2.8 1zm2.6-20.4c-.5.7-1.3 1.3-2.5 1.6-.8.3-2.5.4-4.8.4h-7.7V21.6h7.1c1.4 0 2.6 0 3.6.1s1.7.2 2.2.4c1 .3 1.7.8 2.2 1.7.5.9.8 1.8.8 3-.1 1.3-.4 2.2-.9 3z"/></symbol><symbol id="trumbowyg-close" viewBox="0 0 72 72"><path d="m57 20.5-5.4-5.4-15.5 15.5-15.6-15.5-5.4 5.4L30.7 36 15.1 51.5l5.4 5.4 15.6-15.5 15.5 15.5 5.4-5.4L41.5 36z"/></symbol><symbol id="trumbowyg-create-link" viewBox="0 0 72 72"><path d="m31.1 48.9-6.7 6.7c-.8.8-1.6.9-2.1.9s-1.4-.1-2.1-.9L15 50.4c-1.1-1.1-1.1-3.1 0-4.2l6.1-6.1.2-.2 6.5-6.5c-1.2-.6-2.5-.9-3.8-.9-2.3 0-4.6.9-6.3 2.6L11 41.8c-3.5 3.5-3.5 9.2 0 12.7l5.2 5.2c1.7 1.7 4 2.6 6.3 2.6s4.6-.9 6.3-2.6l6.7-6.7c2.5-2.6 3.1-6.7 1.5-10l-5.9 5.9zm7.6-26.4 6.7-6.7c.8-.8 1.6-.9 2.1-.9s1.4.1 2.1.9l5.2 5.2c1.1 1.1 1.1 3.1 0 4.2l-6.1 6.1-.2.2L42 38c1.2.6 2.5.9 3.8.9 2.3 0 4.6-.9 6.3-2.6l6.7-6.7c3.5-3.5 3.5-9.2 0-12.7l-5.2-5.2c-1.7-1.7-4-2.6-6.3-2.6s-4.6.9-6.3 2.6l-6.7 6.7c-2.7 2.7-3.3 6.9-1.7 10.2l6.1-6.1c0 .1 0 .1 0 0z"/><path d="M44.2 30.5c.2-.2.4-.6.4-.9 0-.3-.1-.6-.4-.9l-2.3-2.3c-.3-.2-.6-.4-.9-.4-.3 0-.6.1-.9.4L25.9 40.6c-.2.2-.4.6-.4.9 0 .3.1.6.4.9l2.3 2.3c.2.2.6.4.9.4.3 0 .6-.1.9-.4l14.2-14.2zm5.7 24.9h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9z"/></symbol><symbol id="trumbowyg-del" viewBox="0 0 72 72"><path d="M45.8 45c0 1-.3 1.9-.9 2.8-.6.9-1.6 1.6-3 2.1s-3.1.8-5 .8c-2.1 0-4-.4-5.7-1.1-1.7-.7-2.9-1.7-3.6-2.7-.8-1.1-1.3-2.6-1.5-4.5l-.1-.8-6.7.6v.9c.1 2.8.9 5.4 2.3 7.6 1.5 2.3 3.5 4 6.1 5.1 2.6 1.1 5.7 1.6 9.4 1.6 2.9 0 5.6-.5 8-1.6 2.4-1.1 4.3-2.7 5.6-4.7 1.3-2 2-4.2 2-6.5 0-1.6-.3-3.1-.9-4.5l-.2-.6H44c0 .1 1.8 2.3 1.8 5.5zM29 28.9c-.8-.8-1.2-1.7-1.2-2.9 0-.7.1-1.3.4-1.9.3-.6.7-1.1 1.4-1.6.6-.5 1.4-.9 2.5-1.1 1.1-.3 2.4-.4 3.9-.4 2.9 0 5 .6 6.3 1.7 1.3 1.1 2.1 2.7 2.4 5.1l.1.9 6.8-.5v-.9c-.1-2.5-.8-4.7-2.1-6.7s-3.2-3.5-5.6-4.5c-2.4-1-5.1-1.5-8.1-1.5-2.8 0-5.3.5-7.6 1.4-2.3 1-4.2 2.4-5.4 4.3-1.2 1.9-1.9 3.9-1.9 6.1 0 1.7.4 3.4 1.2 4.9l.3.5h11.8c-2.3-.9-3.9-1.7-5.2-2.9zm13.3-6.2zm-19.6-2.4zM13 34.1h46.1v3.4H13z"/></symbol><symbol id="trumbowyg-em" viewBox="0 0 72 72"><path d="m26 57 10.1-42h7.2L33.2 57H26z"/></symbol><symbol id="trumbowyg-fullscreen" viewBox="0 0 72 72"><path d="M25.2 7.1H7.1v17.7l6.7-6.5 10.5 10.5 4.5-4.5-10.4-10.5zm22 0 6.5 6.7-10.5 10.5 4.5 4.5 10.5-10.4 6.7 6.8V7.1zm.5 36.1-4.5 4.5 10.4 10.5-6.8 6.7h18.1V47.2l-6.7 6.5zm-23.4 0L13.8 53.6l-6.7-6.8v18.1h17.7l-6.5-6.7 10.5-10.5z"/><path fill="currentColor" d="M10.7 28.8h18.1V11.2l-6.6 6.4L11.6 7.1l-4.5 4.5 10.5 10.5zm50.1 0-6.4-6.6 10.5-10.6-4.5-4.5-10.5 10.5-6.7-6.9v18.1zm-.4 36.1 4.5-4.5-10.5-10.5 6.9-6.7H43.2v17.6l6.6-6.4zm-48.8 0 10.5-10.5 6.7 6.9V43.2H11.1l6.5 6.6L7.1 60.4z"/></symbol><symbol id="trumbowyg-h1" viewBox="0 0 72 72"><path d="M6.4 14.9h7.4v16.7h19.1V14.9h7.4V57h-7.4V38H13.8v19H6.4V14.9zm41.4 7.6c1.4 0 2.8-.1 4.1-.4 1.3-.2 2.5-.6 3.6-1.2 1.1-.5 2-1.3 2.8-2.1.8-.9 1.3-1.9 1.5-3.2h5.5v41.2h-7.4v-29H47.8v-5.3z"/></symbol><symbol id="trumbowyg-h2" viewBox="0 0 72 72"><path d="M1.5 14.9h7.4v16.7H28V14.9h7.4V57H28V38H8.8v19H1.5V14.9zm68.7 42H42c0-3.4.9-6.4 2.5-9s3.8-4.8 6.6-6.7c1.3-1 2.7-1.9 4.2-2.9 1.5-.9 2.8-1.9 4-3 1.2-1.1 2.2-2.2 3-3.4.8-1.2 1.2-2.7 1.2-4.3 0-.7-.1-1.5-.3-2.4s-.5-1.6-1-2.4c-.5-.7-1.2-1.3-2.1-1.8-.9-.5-2.1-.7-3.5-.7-1.3 0-2.4.3-3.3.8s-1.6 1.3-2.1 2.2-.9 2-1.2 3.3c-.3 1.3-.4 2.6-.4 4.1h-6.7c0-2.3.3-4.4.9-6.3.6-1.9 1.5-3.6 2.7-5 1.2-1.4 2.7-2.5 4.4-3.3 1.7-.8 3.8-1.2 6.1-1.2 2.5 0 4.6.4 6.3 1.2 1.7.8 3.1 1.9 4.1 3.1 1 1.3 1.8 2.6 2.2 4.1.4 1.5.6 2.9.6 4.2 0 1.6-.3 3.1-.8 4.5-.5 1.3-1.2 2.6-2.1 3.7-.9 1.1-1.8 2.2-2.9 3.1-1.1.9-2.2 1.8-3.4 2.7-1.2.8-2.4 1.6-3.5 2.4-1.2.7-2.3 1.5-3.3 2.2-1 .7-1.9 1.5-2.6 2.3-.7.8-1.3 1.7-1.5 2.6h20.1v5.9z"/></symbol><symbol id="trumbowyg-h3" viewBox="0 0 72 72"><path d="M1.4 14.5h7.4v16.7h19.1V14.5h7.4v42.1h-7.4v-19H8.8v19H1.4V14.5zm51.7 17.9c1.1 0 2.2 0 3.3-.2 1.1-.2 2.1-.5 2.9-1 .9-.5 1.6-1.2 2.1-2 .5-.9.8-1.9.8-3.2 0-1.8-.6-3.2-1.8-4.2-1.2-1.1-2.7-1.6-4.6-1.6-1.2 0-2.2.2-3.1.7-.9.5-1.6 1.1-2.2 1.9-.6.8-1 1.7-1.3 2.7-.3 1-.4 2-.4 3.1h-6.7c.1-2 .5-3.9 1.1-5.6.7-1.7 1.6-3.2 2.7-4.4s2.6-2.2 4.2-2.9c1.6-.7 3.5-1.1 5.6-1.1 1.6 0 3.2.2 4.7.7 1.6.5 2.9 1.2 4.2 2.1 1.2.9 2.2 2.1 3 3.4.7 1.4 1.1 3 1.1 4.8 0 2.1-.5 3.9-1.4 5.4-.9 1.6-2.4 2.7-4.4 3.4v.1c2.4.5 4.2 1.6 5.5 3.5 1.3 1.9 2 4.1 2 6.8 0 2-.4 3.7-1.2 5.3-.8 1.6-1.8 2.9-3.2 3.9-1.3 1.1-2.9 1.9-4.7 2.5-1.8.6-3.6.9-5.6.9-2.4 0-4.5-.3-6.3-1s-3.3-1.7-4.5-2.9c-1.2-1.3-2.1-2.8-2.7-4.5-.6-1.8-1-3.7-1-5.9h6.7c-.1 2.5.5 4.6 1.9 6.3 1.3 1.7 3.3 2.5 5.9 2.5 2.2 0 4.1-.6 5.6-1.9 1.5-1.3 2.3-3.1 2.3-5.4 0-1.6-.3-2.9-.9-3.8-.6-.9-1.5-1.7-2.5-2.2-1-.5-2.2-.8-3.4-.9-1.3-.1-2.6-.2-3.9-.1v-5.2z"/></symbol><symbol id="trumbowyg-h4" viewBox="0 0 72 72"><path d="M1.5 14.9h7.4v16.7H28V14.9h7.4V57H28V38H8.9v19H1.5V14.9zm69 32.3h-5.3V57h-6.4v-9.8H41.2v-6.7l17.7-24.8h6.4v26.2h5.3v5.3zm-24.2-5.3h12.5V23.7h-.1L46.3 41.9z"/></symbol><symbol id="trumbowyg-h5" viewBox="0 0 72 72"><path d="M1.5 14.9h7.4v16.7H28V14.9h7.4V57H28V38H8.9v19H1.5V14.9zm67.543 27.468q0 5.655-3.92 10.154-3.856 4.434-9.383 4.434-6.105 0-9.768-2.892-3.599-2.891-3.728-8.033h6.62q0 2.892 1.735 4.37 1.735 1.478 4.691 1.478 3.085 0 5.142-2.57 2.056-2.57 2.056-6.748 0-8.869-6.426-8.869-4.692 0-7.327 5.463h-5.848l.9-24.292h22.75v5.398H50.02l-.643 12.21q3.02-3.599 8.355-3.599 5.205 0 8.226 3.985 3.084 3.92 3.084 9.511z"/></symbol><symbol id="trumbowyg-h6" viewBox="0 0 72 72"><path d="M1.5 14.9h7.4v16.7H28V14.9h7.4V57H28V38H8.9v19H1.5z"/><path d="M69.188 43.56q0 2.269-.63 4.475-.63 2.206-2.017 4.286t-4.097 3.403q-2.71 1.261-6.366 1.261-4.349 0-7.185-1.324-2.773-1.386-4.16-4.16-1.386-2.836-1.89-6.113t-.505-8.194q0-22.312 14.181-22.312 10.4 0 11.66 10.526h-6.177q-.378-5.61-5.483-5.61-2.521 0-4.223 1.766-1.702 1.701-2.458 4.538-.693 2.836-1.008 5.168-.252 2.269-.252 4.664 1.575-2.458 3.53-3.719 2.016-1.323 5.42-1.323 3.34 0 5.735 1.26 2.458 1.198 3.656 3.215 1.197 2.017 1.701 4.033.568 2.017.568 4.16zm-6.492.252q0-8.193-6.555-8.193-6.68 0-6.68 8.193 0 8.257 6.68 8.257 6.555 0 6.555-8.257z" aria-label="6"/></symbol><symbol id="trumbowyg-horizontal-rule" viewBox="0 0 72 72"><path d="M9.1 32h54v8h-54z"/></symbol><symbol id="trumbowyg-insert-image" viewBox="0 0 72 72"><path d="M64 17v38H8V17h56m8-8H0v54h72V9z"/><path d="M17.5 22C15 22 13 24 13 26.5s2 4.5 4.5 4.5 4.5-2 4.5-4.5-2-4.5-4.5-4.5zM16 50h27L29.5 32zm20-13.8 8.9-8.5L60.2 50H45.9S35.6 35.9 36 36.2z"/></symbol><symbol id="trumbowyg-italic" viewBox="0 0 72 72"><path d="m26 57 10.1-42h7.2L33.2 57H26z"/></symbol><symbol id="trumbowyg-justify-center" viewBox="0 0 72 72"><path d="M9 14h54v8H9zm0 36h54v8H9zm9-18h36v8H18z"/></symbol><symbol id="trumbowyg-justify-full" viewBox="0 0 72 72"><path d="M9 14h54v8H9zm0 36h54v8H9zm0-18h54v8H9z"/></symbol><symbol id="trumbowyg-justify-left" viewBox="0 0 72 72"><path d="M9 14h54v8H9zm0 36h54v8H9zm0-18h36v8H9z"/></symbol><symbol id="trumbowyg-justify-right" viewBox="0 0 72 72"><path d="M9 14h54v8H9zm0 36h54v8H9zm18-18h36v8H27z"/></symbol><symbol id="trumbowyg-link" viewBox="0 0 72 72"><path d="m30.9 49.1-6.7 6.7c-.8.8-1.6.9-2.1.9s-1.4-.1-2.1-.9l-5.2-5.2c-1.1-1.1-1.1-3.1 0-4.2l6.1-6.1.2-.2 6.5-6.5c-1.2-.6-2.5-.9-3.8-.9-2.3 0-4.6.9-6.3 2.6L10.8 42c-3.5 3.5-3.5 9.2 0 12.7l5.2 5.2c1.7 1.7 4 2.6 6.3 2.6s4.6-.9 6.3-2.6l6.7-6.7C38 50.5 38.6 46.3 37 43l-6.1 6.1zm7.6-26.4 6.7-6.7c.8-.8 1.6-.9 2.1-.9s1.4.1 2.1.9l5.2 5.2c1.1 1.1 1.1 3.1 0 4.2l-6.1 6.1-.2.2-6.5 6.5c1.2.6 2.5.9 3.8.9 2.3 0 4.6-.9 6.3-2.6l6.7-6.7c3.5-3.5 3.5-9.2 0-12.7l-5.2-5.2c-1.7-1.7-4-2.6-6.3-2.6s-4.6.9-6.3 2.6l-6.7 6.7c-2.7 2.7-3.3 6.9-1.7 10.2l6.1-6.1z"/><path d="M44.1 30.7c.2-.2.4-.6.4-.9 0-.3-.1-.6-.4-.9l-2.3-2.3c-.2-.2-.6-.4-.9-.4-.3 0-.6.1-.9.4L25.8 40.8c-.2.2-.4.6-.4.9 0 .3.1.6.4.9l2.3 2.3c.2.2.6.4.9.4.3 0 .6-.1.9-.4l14.2-14.2z"/></symbol><symbol id="trumbowyg-ordered-list" viewBox="0 0 72 72"><path d="M27 14h36v8H27zm0 36h36v8H27zm0-18h36v8H27zM11.8 15.8V22h1.8v-7.8h-1.5l-2.1 1 .3 1.3zm.3 22.7.7-.6c1.1-1 2.1-2.1 2.1-3.4 0-1.4-1-2.4-2.7-2.4-1.1 0-2 .4-2.6.8l.5 1.3c.4-.3 1-.6 1.7-.6.9 0 1.3.5 1.3 1.1 0 .9-.9 1.8-2.6 3.3l-1 .9V40H15v-1.5h-2.9zm1.2 15.4c1-.4 1.4-1 1.4-1.8 0-1.1-.9-1.9-2.6-1.9-1 0-1.9.3-2.4.6l.4 1.3c.3-.2 1-.5 1.6-.5.8 0 1.2.3 1.2.8 0 .7-.8.9-1.4.9h-.7v1.3h.7c.8 0 1.6.3 1.6 1.1 0 .6-.5 1-1.4 1-.7 0-1.5-.3-1.8-.5l-.4 1.4c.5.3 1.3.6 2.3.6 2 0 3.2-1 3.2-2.4 0-1.1-.8-1.8-1.7-1.9z"/></symbol><symbol id="trumbowyg-p" viewBox="0 0 72 72"><path d="M47.8 15.1H30.1c-4.7 0-8.5 3.7-8.5 8.4s3.7 8.4 8.4 8.4v25h7V19.8h3v37.1h4.1V19.8h3.7v-4.7z"/></symbol><symbol id="trumbowyg-redo" viewBox="0 0 72 72"><path d="M10.8 51.2c0-5.1 2.1-9.7 5.4-13.1 3.3-3.3 8-5.4 13.1-5.4H46v-12L61.3 36 45.9 51.3V39.1H29.3c-3.3 0-6.4 1.3-8.5 3.5-2.2 2.2-3.5 5.2-3.5 8.5h-6.5z"/></symbol><symbol id="trumbowyg-removeformat" viewBox="0 0 72 72"><path d="M58.2 54.6 52 48.5l3.6-3.6 6.1 6.1 6.4-6.4 3.8 3.8-6.4 6.4 6.1 6.1-3.6 3.6-6.1-6.1-6.4 6.4-3.7-3.8 6.4-6.4zm-36.5-2.5H50V57H21.7zm-2.9-36.9h34.1v6.4H39.5v24.2h-7.4V21.5H18.8v-6.3z"/></symbol><symbol id="trumbowyg-strikethrough" viewBox="0 0 72 72"><path d="M45.8 45c0 1-.3 1.9-.9 2.8-.6.9-1.6 1.6-3 2.1s-3.1.8-5 .8c-2.1 0-4-.4-5.7-1.1-1.7-.7-2.9-1.7-3.6-2.7-.8-1.1-1.3-2.6-1.5-4.5l-.1-.8-6.7.6v.9c.1 2.8.9 5.4 2.3 7.6 1.5 2.3 3.5 4 6.1 5.1 2.6 1.1 5.7 1.6 9.4 1.6 2.9 0 5.6-.5 8-1.6 2.4-1.1 4.3-2.7 5.6-4.7 1.3-2 2-4.2 2-6.5 0-1.6-.3-3.1-.9-4.5l-.2-.6H44c0 .1 1.8 2.3 1.8 5.5zM29 28.9c-.8-.8-1.2-1.7-1.2-2.9 0-.7.1-1.3.4-1.9.3-.6.7-1.1 1.4-1.6.6-.5 1.4-.9 2.5-1.1 1.1-.3 2.4-.4 3.9-.4 2.9 0 5 .6 6.3 1.7 1.3 1.1 2.1 2.7 2.4 5.1l.1.9 6.8-.5v-.9c-.1-2.5-.8-4.7-2.1-6.7s-3.2-3.5-5.6-4.5c-2.4-1-5.1-1.5-8.1-1.5-2.8 0-5.3.5-7.6 1.4-2.3 1-4.2 2.4-5.4 4.3-1.2 1.9-1.9 3.9-1.9 6.1 0 1.7.4 3.4 1.2 4.9l.3.5h11.8c-2.3-.9-3.9-1.7-5.2-2.9zm13.3-6.2zm-19.6-2.4zM13 34.1h46.1v3.4H13z"/></symbol><symbol id="trumbowyg-strong" viewBox="0 0 72 72"><path d="M51.1 37.8c-1.1-1.4-2.5-2.5-4.2-3.3 1.2-.8 2.1-1.8 2.8-3 1-1.6 1.5-3.5 1.5-5.3 0-2-.6-4-1.7-5.8-1.1-1.8-2.8-3.2-4.8-4.1-2-.9-4.6-1.3-7.8-1.3h-16v42h16.3c2.6 0 4.8-.2 6.7-.7 1.9-.5 3.4-1.2 4.7-2.1 1.3-1 2.4-2.4 3.2-4.1.9-1.7 1.3-3.6 1.3-5.7.2-2.5-.5-4.7-2-6.6zM40.8 50.2c-.6.1-1.8.2-3.4.2h-9V38.5h8.3c2.5 0 4.4.2 5.6.6 1.2.4 2 1 2.7 2 .6.9 1 2 1 3.3 0 1.1-.2 2.1-.7 2.9-.5.9-1 1.5-1.7 1.9-.8.4-1.7.8-2.8 1zm2.6-20.4c-.5.7-1.3 1.3-2.5 1.6-.8.3-2.5.4-4.8.4h-7.7V21.6h7.1c1.4 0 2.6 0 3.6.1s1.7.2 2.2.4c1 .3 1.7.8 2.2 1.7.5.9.8 1.8.8 3-.1 1.3-.4 2.2-.9 3z"/></symbol><symbol id="trumbowyg-subscript" viewBox="0 0 72 72"><path d="M32 15h7.8L56 57.1h-7.9L44.3 46H27.4l-4 11.1h-7.6L32 15zm-2.5 25.4h12.9L36 22.3h-.2l-6.3 18.1zm29.2 19.5c.6-1.4 2-2.8 4.1-4.4 1.9-1.3 3.1-2.3 3.7-2.9.8-.9 1.3-1.9 1.3-3 0-.9-.2-1.6-.7-2.2-.5-.6-1.2-.9-2.1-.9-1.2 0-2.1.5-2.5 1.4-.3.5-.4 1.4-.5 2.5h-4c.1-1.8.4-3.2 1-4.3 1.1-2.1 3-3.1 5.8-3.1 2.2 0 3.9.6 5.2 1.8 1.3 1.2 1.9 2.8 1.9 4.8 0 1.5-.5 2.9-1.4 4.1-.6.8-1.6 1.7-3 2.6L66 57.7c-1 .7-1.7 1.2-2.1 1.6-.4.3-.7.7-1 1.1H72V64H57.8c0-1.5.3-2.8.9-4.1z"/></symbol><symbol id="trumbowyg-superscript" viewBox="0 0 72 72"><path d="M32 15h7.8L56 57.1h-7.9l-4-11.1H27.4l-4 11.1h-7.6L32 15zm-2.5 25.4h12.9L36 22.3h-.2l-6.3 18.1zm20.1-11.6c.5-1.1 1.6-2.3 3.4-3.6 1.5-1.1 2.5-1.9 3-2.4.7-.7 1-1.6 1-2.4 0-.7-.2-1.3-.6-1.8-.4-.5-1-.7-1.7-.7-1 0-1.7.4-2.1 1.1-.2.4-.3 1.1-.4 2.1H49c.1-1.5.3-2.6.8-3.5.9-1.7 2.5-2.6 4.8-2.6 1.8 0 3.2.5 4.3 1.5 1.1 1 1.6 2.3 1.6 4 0 1.3-.4 2.4-1.1 3.4-.5.7-1.3 1.4-2.4 2.2l-1.3 1c-.8.6-1.4 1-1.7 1.3-.3.3-.6.6-.8.9h7.4v3H48.8c0-1.3.3-2.4.8-3.5z"/></symbol><symbol id="trumbowyg-underline" viewBox="0 0 72 72"><path d="M36 35zM15.2 55.9h41.6V59H15.2zm5.9-42h6.4v21.2c0 1.2.1 2.5.2 3.7.1 1.3.5 2.4 1 3.4.6 1 1.4 1.8 2.6 2.5 1.1.6 2.7 1 4.8 1 2.1 0 3.7-.3 4.8-1 1.1-.6 2-1.5 2.6-2.5.6-1 .9-2.1 1-3.4.1-1.3.2-2.5.2-3.7V13.9H51v23.3c0 2.3-.4 4.4-1.1 6.1-.7 1.7-1.7 3.2-3 4.4-1.3 1.2-2.9 2-4.7 2.6-1.8.6-3.9.9-6.1.9-2.2 0-4.3-.3-6.1-.9-1.8-.6-3.4-1.5-4.7-2.6-1.3-1.2-2.3-2.6-3-4.4-.7-1.7-1.1-3.8-1.1-6.1V13.9z"/></symbol><symbol id="trumbowyg-undo" viewBox="0 0 72 72"><path d="M61.2 51.2c0-5.1-2.1-9.7-5.4-13.1-3.3-3.3-8-5.4-13.1-5.4H26.1v-12L10.8 36l15.3 15.3V39.1h16.7c3.3 0 6.4 1.3 8.5 3.5 2.2 2.2 3.5 5.2 3.5 8.5h6.4z"/></symbol><symbol id="trumbowyg-unlink" viewBox="0 0 72 72"><path d="m30.9 49.1-6.7 6.7c-.8.8-1.6.9-2.1.9s-1.4-.1-2.1-.9l-5.2-5.2c-1.1-1.1-1.1-3.1 0-4.2l6.1-6.1.2-.2 6.5-6.5c-1.2-.6-2.5-.9-3.8-.9-2.3 0-4.6.9-6.3 2.6L10.8 42c-3.5 3.5-3.5 9.2 0 12.7l5.2 5.2c1.7 1.7 4 2.6 6.3 2.6s4.6-.9 6.3-2.6l6.7-6.7C38 50.5 38.6 46.3 37 43l-6.1 6.1zm7.6-26.4 6.7-6.7c.8-.8 1.6-.9 2.1-.9s1.4.1 2.1.9l5.2 5.2c1.1 1.1 1.1 3.1 0 4.2l-6.1 6.1-.2.2-6.5 6.5c1.2.6 2.5.9 3.8.9 2.3 0 4.6-.9 6.3-2.6l6.7-6.7c3.5-3.5 3.5-9.2 0-12.7l-5.2-5.2c-1.7-1.7-4-2.6-6.3-2.6s-4.6.9-6.3 2.6l-6.7 6.7c-2.7 2.7-3.3 6.9-1.7 10.2l6.1-6.1z"/><path d="M44.1 30.7c.2-.2.4-.6.4-.9 0-.3-.1-.6-.4-.9l-2.3-2.3c-.2-.2-.6-.4-.9-.4-.3 0-.6.1-.9.4L25.8 40.8c-.2.2-.4.6-.4.9 0 .3.1.6.4.9l2.3 2.3c.2.2.6.4.9.4.3 0 .6-.1.9-.4l14.2-14.2zm-2.8 25.1v-5h22.2v5H41.3z"/></symbol><symbol id="trumbowyg-unordered-list" viewBox="0 0 72 72"><path d="M27 14h36v8H27zm0 36h36v8H27zM9 50h9v8H9zm0-18h9v8H9zm0-18h9v8H9zm18 18h36v8H27z"/></symbol><symbol id="trumbowyg-view-html" viewBox="0 0 72 72"><path fill="none" stroke="currentColor" stroke-width="8" stroke-miterlimit="10" d="M26.9 17.9 9 36.2 26.9 54M45 54l17.9-18.3L45 17.9"/></symbol><symbol id="trumbowyg-base64" viewBox="0 0 72 72"><path d="M64 17v38H8V17h56m8-8H0v54h72V9z"/><path d="M29.9 28.9c-.5-.5-1.1-.8-1.8-.8s-1.4.2-1.9.7c-.5.4-.9 1-1.2 1.6-.3.6-.5 1.3-.6 2.1-.1.7-.2 1.4-.2 1.9l.1.1c.6-.8 1.2-1.4 2-1.8.8-.4 1.7-.5 2.7-.5.9 0 1.8.2 2.6.6.8.4 1.6.9 2.2 1.5.6.6 1 1.3 1.2 2.2.3.8.4 1.6.4 2.5 0 1.1-.2 2.1-.5 3-.3.9-.8 1.7-1.5 2.4-.6.7-1.4 1.2-2.3 1.6-.9.4-1.9.6-3 .6-1.6 0-2.8-.3-3.9-.9-1-.6-1.8-1.4-2.5-2.4-.6-1-1-2.1-1.3-3.4-.2-1.3-.4-2.6-.4-3.9 0-1.3.1-2.6.4-3.8.3-1.3.8-2.4 1.4-3.5.7-1 1.5-1.9 2.5-2.5 1-.6 2.3-1 3.8-1 .9 0 1.7.1 2.5.4.8.3 1.4.6 2 1.1.6.5 1.1 1.1 1.4 1.8.4.7.6 1.5.7 2.5h-4c0-1-.3-1.6-.8-2.1zm-3.5 6.8c-.4.2-.8.5-1 .8-.3.4-.5.8-.6 1.2-.1.5-.2 1-.2 1.5s.1.9.2 1.4c.1.5.4.9.6 1.2.3.4.6.7 1 .9.4.2.9.3 1.4.3.5 0 1-.1 1.3-.3.4-.2.7-.5 1-.9.3-.4.5-.8.6-1.2.1-.5.2-.9.2-1.4 0-.5-.1-1-.2-1.4-.1-.5-.3-.9-.6-1.2-.3-.4-.6-.7-1-.9-.4-.2-.9-.3-1.4-.3-.4 0-.9.1-1.3.3zm9.9 5.6v-3.8l9-12.1H49v12.4h2.7v3.5H49v4.8h-4v-4.8h-8.7zM45 30.7l-5.3 7.2h5.4l-.1-7.2z"/></symbol><symbol id="trumbowyg-back-color" viewBox="0 0 72 72"><path d="m36.5 22.3-6.3 18.1H43l-6.3-18.1z"/><path d="M9 8.9v54.2h54.1V8.9H9zm39.9 48.2L45 46H28.2l-3.9 11.1h-7.6L32.8 15h7.8l16.2 42.1h-7.9z"/></symbol><symbol id="trumbowyg-fore-color" viewBox="0 0 72 72"><path d="M32 15h7.8L56 57.1h-7.9l-4-11.1H27.4l-4 11.1h-7.6L32 15zm-2.5 25.4h12.9L36 22.3h-.2l-6.3 18.1z"/></symbol><symbol id="trumbowyg-emoji" viewBox="0 0 72 72"><path d="M36.05 9C21.09 9 8.949 21.141 8.949 36.101c0 14.96 12.141 27.101 27.101 27.101 14.96 0 27.101-12.141 27.101-27.101S51.01 9 36.05 9zm9.757 15.095c2.651 0 4.418 1.767 4.418 4.418s-1.767 4.418-4.418 4.418-4.418-1.767-4.418-4.418 1.767-4.418 4.418-4.418zm-19.479 0c2.651 0 4.418 1.767 4.418 4.418s-1.767 4.418-4.418 4.418-4.418-1.767-4.418-4.418 1.767-4.418 4.418-4.418zm9.722 30.436c-14.093 0-16.261-13.009-16.261-13.009h32.522S50.143 54.531 36.05 54.531z"/></symbol><symbol id="trumbowyg-fontsize" viewBox="0 0 24 24"><path d="M9 4v3h5v12h3V7h5V4H9zm-6 8h3v7h3v-7h3V9H3v3z"/></symbol><symbol id="trumbowyg-giphy" viewBox="0 0 72 72"><path d="M15.676 40.149v-5.282h13.645v12.489c-1.326 1.283-3.248 2.413-5.764 3.39-2.516.977-5.065 1.465-7.646 1.465-3.279 0-6.137-.688-8.575-2.064-2.439-1.376-4.271-3.343-5.497-5.903C.613 41.685 0 38.901 0 35.893c0-3.265.684-6.166 2.053-8.704 1.369-2.538 3.372-4.484 6.01-5.839 2.01-1.04 4.512-1.561 7.506-1.561 3.893 0 6.933.816 9.122 2.449 2.188 1.632 3.596 3.889 4.223 6.769l-6.287 1.176c-.442-1.54-1.273-2.755-2.492-3.646-1.219-.892-2.741-1.337-4.566-1.337-2.766 0-4.965.877-6.597 2.63-1.633 1.754-2.449 4.356-2.449 7.806 0 3.722.827 6.513 2.481 8.373 1.654 1.861 3.821 2.791 6.501 2.791 1.326 0 2.656-.26 3.989-.781 1.333-.52 2.477-1.151 3.432-1.892v-3.978h-7.25zm20.892-19.825h6.33v31.352h-6.33zm13.939 31.352V20.324H72v5.304H56.837v7.421h13.089v5.303H56.837v13.324h-6.33z"/></symbol><symbol id="trumbowyg-highlight" viewBox="0 0 60 60"><path d="M11 7c0-2.206-1.794-4-4-4S3 4.794 3 7s1.794 4 4 4 4-1.794 4-4zM7 9c-1.103 0-2-.897-2-2s.897-2 2-2 2 .897 2 2-.897 2-2 2zm9 2c2.206 0 4-1.794 4-4s-1.794-4-4-4-4 1.794-4 4 1.794 4 4 4zm0-6c1.103 0 2 .897 2 2s-.897 2-2 2-2-.897-2-2 .897-2 2-2zm9 6c2.206 0 4-1.794 4-4s-1.794-4-4-4-4 1.794-4 4 1.794 4 4 4zm0-6c1.103 0 2 .897 2 2s-.897 2-2 2-2-.897-2-2 .897-2 2-2z"/><path d="M0 0v60h60V0H0zm2 2h56v10H2V2zm0 56V14h5v44H2zm56 0H9V14h49v44z"/><path d="M5 17H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm0 4H4a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2zm8-34h13a1 1 0 1 0 0-2H13a1 1 0 1 0 0 2zm17 0h10a1 1 0 1 0 0-2H30a1 1 0 1 0 0 2zm14 0h2a1 1 0 1 0 0-2h-2a1 1 0 1 0 0 2zm-9 3a1 1 0 0 0 1 1h15a1 1 0 1 0 0-2H36a1 1 0 0 0-1 1zm-3-1H18a1 1 0 1 0 0 2h14a1 1 0 1 0 0-2zm-19 2h1a1 1 0 1 0 0-2h-1a1 1 0 1 0 0 2zm0 4h9a1 1 0 1 0 0-2h-9a1 1 0 1 0 0 2zm13 0h2a1 1 0 1 0 0-2h-2a1 1 0 1 0 0 2zm20-2H32a1 1 0 1 0 0 2h14a1 1 0 1 0 0-2zm-33 6h13a1 1 0 1 0 0-2H13a1 1 0 1 0 0 2zm28-1a1 1 0 0 0-1-1H30a1 1 0 1 0 0 2h10a1 1 0 0 0 1-1zm-5 5h8a1 1 0 1 0 0-2h-8a1 1 0 1 0 0 2zm-19-1a1 1 0 0 0 1 1h14a1 1 0 1 0 0-2H18a1 1 0 0 0-1 1zm-4 1h1a1 1 0 1 0 0-2h-1a1 1 0 1 0 0 2zm0 4h9a1 1 0 1 0 0-2h-9a1 1 0 1 0 0 2zm13 0h2a1 1 0 1 0 0-2h-2a1 1 0 1 0 0 2zm5-1a1 1 0 0 0 1 1h15a1 1 0 1 0 0-2H32a1 1 0 0 0-1 1zm-18 5h13a1 1 0 1 0 0-2H13a1 1 0 1 0 0 2zm27-2H30a1 1 0 1 0 0 2h10a1 1 0 1 0 0-2zm11 0h-7a1 1 0 1 0 0 2h7a1 1 0 1 0 0-2zm-11 4h-4a1 1 0 1 0 0 2h4a1 1 0 1 0 0-2zm-23 1a1 1 0 0 0 1 1h14a1 1 0 1 0 0-2H18a1 1 0 0 0-1 1zm-4 1h1a1 1 0 1 0 0-2h-1a1 1 0 1 0 0 2zm9 2h-9a1 1 0 1 0 0 2h9a1 1 0 1 0 0-2zm6 0h-2a1 1 0 1 0 0 2h2a1 1 0 1 0 0-2zm11 0h-7a1 1 0 1 0 0 2h7a1 1 0 1 0 0-2zm5 0h-1a1 1 0 1 0 0 2h1a1 1 0 1 0 0-2z"/></symbol><symbol id="trumbowyg-indent" viewBox="0 0 467.765 467.765"><path d="M181.412 151.176h292.353v58.471H181.412zm0 120.942h292.353v58.471H181.412zM0 393.059h467.765v58.471H0zM0 30.235h467.765v58.471H0zm0 320.589V116.941l116.941 116.941z"/></symbol><symbol id="trumbowyg-outdent" viewBox="0 0 467.765 467.765"><path d="M181.412 151.176h292.353v58.471H181.412zm0 120.942h292.353v58.471H181.412zM0 393.059h467.765v58.471H0zM0 30.235h467.765v58.471H0zm0 203.647 116.941-116.941v233.882z"/></symbol><symbol id="trumbowyg-insert-audio" viewBox="-2 -2 12 12"><path d="M3.344 0 2 2H0v4h2l1.344 2H4V0h-.656zM5 1v1c.152 0 .313.026.469.063H5.5c.86.215 1.5.995 1.5 1.938a1.99 1.99 0 0 1-2 2.001v1a2.988 2.988 0 0 0 3-3 2.988 2.988 0 0 0-3-3zm0 2v2l.25-.031C5.683 4.851 6 4.462 6 4c0-.446-.325-.819-.75-.938v-.031h-.031L5 3z"/></symbol><symbol id="trumbowyg-lineheight" viewBox="0 0 72 72"><path fill="currentColor" d="M31 14h36v8H31zm0 36h36v8H31zm0-18h30v8H31z"/><path fill="none" stroke="currentColor" stroke-miterlimit="10" stroke-width="3.643" d="m7.82 47.207 8.332 8.15 8.106-8.15m.018-22.572-8.333-8.15-8.105 8.15"/><path fill="currentColor" d="M14.348 53.761v-36h3.384v36z"/></symbol><symbol id="trumbowyg-mathml" viewBox="0 0 445.878 445.878"><path d="M426.024 86.447H209.705l-84.911 298.911c-2.568 7.967-9.854 13.482-18.22 13.771-.236 0-.464.006-.688.006a19.868 19.868 0 0 1-18.436-12.478l-34.714-86.782H19.851C8.884 299.876 0 290.986 0 280.022c0-10.965 8.893-19.854 19.851-19.854H66.18a19.862 19.862 0 0 1 18.436 12.483l19.237 48.09 72.472-260.218a19.855 19.855 0 0 1 18.903-13.781h230.798c10.97 0 19.854 8.89 19.854 19.851s-8.892 19.854-19.856 19.854zm10.699 266.78-78.259-87.904 74.576-82.783c1.318-1.454 1.638-3.547.857-5.341a4.977 4.977 0 0 0-4.54-2.946h-47.18a4.995 4.995 0 0 0-3.759 1.72l-50.059 58.047-49.674-58.029a4.95 4.95 0 0 0-3.771-1.738H225.58a4.947 4.947 0 0 0-4.521 2.929 4.939 4.939 0 0 0 .824 5.332l73.743 82.81-77.641 87.923a4.977 4.977 0 0 0-.813 5.325 4.978 4.978 0 0 0 4.528 2.92h48.9c1.472 0 2.867-.65 3.807-1.785l51.819-62.181 53.05 62.229a4.972 4.972 0 0 0 3.782 1.743h49.97a4.938 4.938 0 0 0 4.527-2.926 4.966 4.966 0 0 0-.832-5.345z"/></symbol><symbol id="trumbowyg-mention" viewBox="0 0 128 128"><path fill-rule="evenodd" d="M73.309 62.5c-1.53 9.86-8.16 17.85-14.45 17.85-5.61 0-8.5-4.08-8.5-10.54 0-13.089 8.84-24.139 20.06-24.139 2.21 0 3.91.34 5.27.68L73.309 62.5zm14.45 44.2c-6.8 3.57-15.98 5.44-24.65 5.44-25.329 0-43.519-16.15-43.519-44.54 0-32.469 22.78-52.869 48.789-52.869 26.35 0 40.63 17.17 40.63 39.27 0 19.549-9.18 28.899-16.49 28.729-4.76-.17-5.95-4.76-4.25-14.79l5.1-31.449c-4.25-2.38-12.75-4.25-20.23-4.25-24.48 0-39.779 18.87-39.779 39.609 0 13.94 7.99 22.1 19.039 22.1 9.01 0 16.66-4.42 21.93-13.09h.34c.85 9.01 6.63 13.09 14.62 13.09 18.36 0 32.3-15.64 32.3-40.459 0-28.56-21.42-49.13-51.34-49.13C31.83 4.361 6.67 34.451 6.67 69.13c0 33.32 24.82 53.55 53.039 53.55 12.07 0 20.91-1.53 31.11-6.12l-3.06-9.86z"/></symbol><symbol id="trumbowyg-noembed" viewBox="0 0 72 72"><path d="M31.5 33.6V25l11 11-11 11v-8.8z"/><path d="M64 17v38H8V17h56m8-8H0v54h72V9z"/></symbol><symbol id="trumbowyg-preformatted" viewBox="0 0 72 72"><path d="M10.3 33.5c.4 0 .9-.1 1.5-.2s1.2-.3 1.8-.7c.6-.3 1.1-.8 1.5-1.3.4-.5.6-1.3.6-2.1V17.1c0-1.4.3-2.6.8-3.6s1.2-1.9 2-2.5c.8-.7 1.6-1.2 2.5-1.5.9-.3 1.6-.5 2.2-.5h5.3v5.3h-3.2c-.7 0-1.3.1-1.8.4-.4.3-.8.6-1 1-.2.4-.4.9-.4 1.3-.1.5-.1.9-.1 1.4v11.4c0 1.2-.2 2.1-.7 2.9-.5.8-1 1.4-1.7 1.8-.6.4-1.3.8-2 1-.7.2-1.3.3-1.7.4v.1c.5 0 1 .1 1.7.3.7.2 1.3.5 2 .9.6.5 1.2 1.1 1.7 1.9.5.8.7 2 .7 3.4v11.1c0 .4 0 .9.1 1.4.1.5.2.9.4 1.3s.6.7 1 1c.4.3 1 .4 1.8.4h3.2V63h-5.3c-.6 0-1.4-.2-2.2-.5-.9-.3-1.7-.8-2.5-1.5s-1.4-1.5-2-2.5c-.5-1-.8-2.2-.8-3.6V43.5c0-.9-.2-1.7-.6-2.3-.4-.6-.9-1.1-1.5-1.5-.6-.4-1.2-.6-1.8-.7-.6-.1-1.1-.2-1.5-.2v-5.3zm51.5 5.2c-.4 0-1 .1-1.6.2-.6.1-1.2.4-1.8.7-.6.3-1.1.7-1.5 1.3-.4.5-.6 1.3-.6 2.1v12.1c0 1.4-.3 2.6-.8 3.6s-1.2 1.9-2 2.5c-.8.7-1.6 1.2-2.5 1.5-.9.3-1.6.5-2.2.5h-5.3v-5.3h3.2c.7 0 1.3-.1 1.8-.4.4-.3.8-.6 1-1 .2-.4.4-.9.4-1.3.1-.5.1-.9.1-1.4V42.3c0-1.2.2-2.1.7-2.9.5-.8 1-1.4 1.7-1.8.6-.4 1.3-.8 2-1 .7-.2 1.3-.3 1.7-.4v-.1c-.5 0-1-.1-1.7-.3-.7-.2-1.3-.5-2-.9-.6-.4-1.2-1.1-1.7-1.9-.5-.8-.7-2-.7-3.4V18.5c0-.4 0-.9-.1-1.4-.1-.5-.2-.9-.4-1.3s-.6-.7-1-1c-.4-.3-1-.4-1.8-.4h-3.2V9.1h5.3c.6 0 1.4.2 2.2.5.9.3 1.7.8 2.5 1.5s1.4 1.5 2 2.5c.5 1 .8 2.2.8 3.6v11.6c0 .9.2 1.7.6 2.3.4.6.9 1.1 1.5 1.5.6.4 1.2.6 1.8.7.6.1 1.2.2 1.6.2v5.2z"/></symbol><symbol id="trumbowyg-ruby" viewBox="0 0 72 72"><path d="M16.499 24.477h8.018L41.08 67.5H33l-4.04-11.361H11.804L7.764 67.5H0l16.499-43.023zm-2.65 25.907h13.127l-6.438-18.497h-.177l-6.512 18.497zm51.204-33.699c-6.316 1.178-12.025 1.98-17.126 2.408a362.385 362.385 0 0 0-.965 5.833c-.25 1.57-.679 3.907-1.286 7.013 3.033-1.963 5.852-3.266 8.458-3.907 2.639-.642 4.905-.891 6.797-.75 1.891.108 3.746.661 5.566 1.661 1.82.964 3.264 2.408 4.334 4.334 1.104 1.893 1.427 4.088.965 6.584-.466 2.461-1.554 4.494-3.265 6.101-1.679 1.605-3.658 2.783-5.941 3.532-2.283.785-4.853 1.251-7.707 1.391-2.819.144-5.906.161-9.259.056 0-1.642-.287-3.212-.857-4.71l.108-.59c2.711.5 5.246.768 7.601.802 2.39 0 4.529-.195 6.421-.589 1.927-.393 3.605-1.069 5.031-2.031 1.427-.965 2.319-2.319 2.676-4.067.394-1.75.269-3.229-.373-4.443-.644-1.249-1.446-2.213-2.408-2.891-.929-.68-2.161-1.034-3.693-1.071-1.536-.072-3.265.089-5.192.482-1.927.391-3.82 1.14-5.672 2.248a24.308 24.308 0 0 0-4.978 3.907l-4.872-1.981c1.463-5.031 2.355-8.597 2.677-10.703.321-2.105.642-4.067.963-5.887-3.961.25-7.154.411-9.58.481-.215-1.927-.52-3.534-.91-4.817l.32-.32c3.604.32 7.225.446 10.865.375.214-1.355.481-3.103.804-5.245.354-2.175.407-3.621.16-4.336.034-.784.374-1.017 1.017-.695l5.085.749c.428.251.444.573.055.964l-.857.91c-.537 2.89-.981 5.352-1.338 7.385 4.279-.427 9.312-1.393 15.092-2.89l1.284 4.707"/></symbol><symbol id="trumbowyg-special-chars" viewBox="0 0 72 72"><g fill-rule="evenodd"><path d="M36 3c18.213 0 33 14.787 33 33S54.213 69 36 69 3 54.213 3 36 17.787 3 36 3zm0 6.735c14.496 0 26.265 11.769 26.265 26.265S50.496 62.265 36 62.265 9.735 50.496 9.735 36 21.504 9.735 36 9.735z"/><path d="M45.248 40.04h8.816C52.23 48.325 44.833 54.52 36 54.52c-10.222 0-18.52-8.298-18.52-18.52S25.778 17.48 36 17.48c8.712 0 16.027 6.028 17.977 14.142h-8.912A10.009 10.009 0 0 0 36 25.898c-5.575 0-10.102 4.527-10.102 10.102S30.425 46.102 36 46.102a10.08 10.08 0 0 0 9.248-6.061z"/></g></symbol><symbol id="trumbowyg-speechrecognition" viewBox="0 0 24 24"><g fill="currentColor"><path d="M12 3a3 3 0 0 0-3 3v4a3 3 0 1 0 6 0V6a3 3 0 0 0-3-3Zm0-2a5 5 0 0 1 5 5v4a5 5 0 0 1-10 0V6a5 5 0 0 1 5-5ZM3.055 11H5.07a7.002 7.002 0 0 0 13.858 0h2.016A9.004 9.004 0 0 1 13 18.945V23h-2v-4.055A9.004 9.004 0 0 1 3.055 11Z"/></g></symbol><symbol id="trumbowyg-align-bottom" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M3 18.377h18V21H3v-2.623ZM13.294 13h2.689l-4 4-4-4h2.689V3h2.622v10Z" style="fill-rule:nonzero" transform="translate(-2.533 -2.533) scale(3.21111)"/></g></symbol><symbol id="trumbowyg-align-middle" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path style="fill:none" d="M0 0h24v24H0z" transform="translate(24 24)"/><path d="M3 10.689h18v2.622H3v-2.622Zm10.311 7.622V21h-2.622v-2.689H8l4-4 4 4h-2.689Zm0-12.622H16l-4 4-4-4h2.689V3h2.622v2.689Z" style="fill-rule:nonzero" transform="translate(-2.533 -2.533) scale(3.21111)"/></g></symbol><symbol id="trumbowyg-align-top" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M3 18.377h18V21H3v-2.623ZM13.294 13h2.689l-4 4-4-4h2.689V3h2.622v10Z" style="fill-rule:nonzero" transform="rotate(180 37.267 37.267) scale(3.21111)"/></g></symbol><symbol id="trumbowyg-col-delete" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M22 9h27v54H22V9Zm4 26v10h19V35H26Zm19-14H26v10h19V21ZM26 49v10h19V49H26Z"/><path d="M58.2 54.6 52 48.5l3.6-3.6 6.1 6.1 6.4-6.4 3.8 3.8-6.4 6.4 6.1 6.1-3.6 3.6-6.1-6.1-6.4 6.4-3.7-3.8 6.4-6.4Z" style="fill-rule:nonzero"/></g></symbol><symbol id="trumbowyg-col-left" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M38 9h27v54H38V9Zm4 26v10h19V35H42Zm19-14H42v10h19V21ZM42 49v10h19V49H42Z"/><path d="M49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9Z" style="fill-rule:nonzero" transform="translate(-33.6 -16.9)"/></g></symbol><symbol id="trumbowyg-col-right" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M34.8 9h-27v54h27V9Zm-4 26v10h-19V35h19Zm-19-14h19v10h-19V21Zm19 28v10h-19V49h19Z"/><path d="M49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9Z" style="fill-rule:nonzero" transform="matrix(-1 0 0 1 106.4 -16.9)"/></g></symbol><symbol id="trumbowyg-header-row" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 41h71.9v18H0z"/><path d="M49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9Z" style="fill-rule:nonzero" transform="matrix(-1 0 0 1 88.5 -30.9)"/></g></symbol><symbol id="trumbowyg-row-above" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 59V41h71.9v18H0Zm22-14H4v10h18V45Zm46 0H49v10h19V45Zm-23 0H26v10h19V45Z"/><path d="M49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9Z" style="fill-rule:nonzero" transform="matrix(-1 0 0 1 88.5 -30.9)"/></g></symbol><symbol id="trumbowyg-row-below" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 12.6v18h71.9v-18H0Zm22 14H4v-10h18v10Zm46 0H49v-10h19v10Zm-23 0H26v-10h19v10Z"/><path d="M49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9Z" style="fill-rule:nonzero" transform="rotate(180 44.25 51.25)"/></g></symbol><symbol id="trumbowyg-row-delete" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 36V18h71.9v18H0Zm22-14H4v10h18V22Zm46 0H49v10h19V22Zm-23 0H26v10h19V22Z"/><path d="M58.2 54.6 52 48.5l3.6-3.6 6.1 6.1 6.4-6.4 3.8 3.8-6.4 6.4 6.1 6.1-3.6 3.6-6.1-6.1-6.4 6.4-3.7-3.8 6.4-6.4Z" style="fill-rule:nonzero" transform="translate(0 -5)"/></g></symbol><symbol id="trumbowyg-table-border-color" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M37 63H0V9h72v38l-4-9V21H4v38h33v4Z"/><path d="M55.84 68C49.692 68 43.69 63 43.587 56.852c0-1.667.417-3.23 1.042-4.585l11.21-20.525L67.05 52.267c.625 1.355.938 2.918.938 4.585C67.988 62.999 61.987 68 55.84 68Z"/></g></symbol><symbol id="trumbowyg-table-cell-background-color" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 30.742V9h72v37.813l-4-7.324V35h-2.544l-2.185-4H68V21H49v10l-4 7.071V35H26v-4h19V21H26v9.742h-4V21H4v9.742H0ZM26 45h14.762l-2.185 4H26v-4Zm0 4.258V59h10.77a15.862 15.862 0 0 0 1.196 4H0V49.258h4V59h18v-9.742h4Z" style="fill-opacity:.3"/><path d="M0 33h24v14H0zM55.84 68C49.692 68 43.69 63 43.587 56.852c0-1.667.417-3.23 1.042-4.585l11.21-20.525L67.05 52.267c.625 1.355.938 2.918.938 4.585C67.988 62.999 61.987 68 55.84 68Z"/></g></symbol><symbol id="trumbowyg-table-delete" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M49 63H0V9h72v31h-4v-5H49v25.972l-.01.009.01.01V63Zm-4-42H26v10h19V21ZM4 49v10h18V49H4Zm22-14v10h19V35H26Zm0 14v10h19V49H26ZM4 35v10h18V35H4Zm64-14H49v10h19V21Zm-46 0H4v10h18V21Z"/><path d="M58.2 54.6 52 48.5l3.6-3.6 6.1 6.1 6.4-6.4 3.8 3.8-6.4 6.4 6.1 6.1-3.6 3.6-6.1-6.1-6.4 6.4-3.7-3.8 6.4-6.4Z" style="fill-rule:nonzero"/></g></symbol><symbol id="trumbowyg-table-merge" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M72 9v54H0V9h72Zm-40 8H8v14.789h6.733v-8.633L27.578 36 14.733 48.844v-8.633H8V55h24v-3h8v3h24V40.211h-6.733v8.633L44.422 36l12.845-12.844v8.633H64V17H40v3h-8v-3Zm8 22v8h-8v-8h8Zm0-14v8h-8v-8h8Z"/></g></symbol><symbol id="trumbowyg-table-unmerge" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M72 9v54H0V9h72Zm-40 8H8v38h24v-7h8v7h24V17H40v7h-8v-7Zm13.944 24.211H26.056v7.633L13.211 36l12.845-12.844v8.633h19.888v-8.633L58.789 36 45.944 48.844v-7.633Z"/></g></symbol><symbol id="trumbowyg-table" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M0 63V9h72v54H0Zm22-42H4v10h18V21Zm46 0H49v10h19V21Zm-23 0H26v10h19V21ZM26 49v10h19V49H26Zm0-14v10h19V35H26ZM4 49v10h18V49H4Zm0-14v10h18V35H4Zm64 10V35H49v10h19Zm0 14V49H49v10h19Z"/></g></symbol><symbol id="trumbowyg-tenor" viewBox="0 0 72 72"><path d="M15.676 40.149v-5.282h13.645v12.489c-1.326 1.283-3.248 2.413-5.764 3.39-2.516.977-5.065 1.465-7.646 1.465-3.279 0-6.137-.688-8.575-2.064-2.439-1.376-4.271-3.343-5.497-5.903C.613 41.685 0 38.901 0 35.893c0-3.265.684-6.166 2.053-8.704 1.369-2.538 3.372-4.484 6.01-5.839 2.01-1.04 4.512-1.561 7.506-1.561 3.893 0 6.933.816 9.122 2.449 2.188 1.632 3.596 3.889 4.223 6.769l-6.287 1.176c-.442-1.54-1.273-2.755-2.492-3.646-1.219-.892-2.741-1.337-4.566-1.337-2.766 0-4.965.877-6.597 2.63-1.633 1.754-2.449 4.356-2.449 7.806 0 3.722.827 6.513 2.481 8.373 1.654 1.861 3.821 2.791 6.501 2.791 1.326 0 2.656-.26 3.989-.781 1.333-.52 2.477-1.151 3.432-1.892v-3.978h-7.25zm20.892-19.825h6.33v31.352h-6.33zm13.939 31.352V20.324H72v5.304H56.837v7.421h13.089v5.303H56.837v13.324h-6.33z"/></symbol><symbol id="trumbowyg-upload" viewBox="0 0 72 72"><g style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2"><path d="M32 20h-8L36 6l12 14h-8v30h-8V20Zm32 7h8v36H0V27h8v28h56V27Z"/></g></symbol>
	</svg>
</div>
<div id="notesPanel" class="hidden">
    <div id="notesContainer">

        <div id="notesSidebar">
            <div class="notes-sidebar-header">
                <span>📒 Notes</span>
                <button id="newNoteBtn">+</button>
            </div>

            <div id="notesEntries"></div>
        </div>

        <div id="noteEditorArea">
            <div id="noteTitleRow">
				<input id="noteTitle" placeholder="Title">
				<button id="editNoteBtn" class="note-edit-btn">✏️</button>
			</div>
            <div id="noteContentView" class="note-view"></div>
            <textarea id="noteContent" class="ed"></textarea>

            <div class="note-editor-actions">
                <button id="saveNoteBtn">Save</button>
                <button id="deleteNoteBtn" class="danger">Delete</button>
            </div>
        </div>

    </div>
</div>


<div id="monitor-grid" class="hidden">
    
    <div id="monitor-sidebar">
        <h2>Websites</h2>
        <div id="monitor-url-list"></div>
        <button id="monitor-add-btn">+</button>
    </div>

    <div id="monitor-grid-inner"></div>
<div id="monitor-sidebar-toggle">≡</div>
</div>


<div id="monitor-add-dialog" class="hidden">
    <div class="mad-inner">
        <h2>Add URL</h2>
        <input id="mad-url" type="text" placeholder="https://example.com">
        <button id="mad-save">Add</button>
        <button id="mad-cancel">Cancel</button>
    </div>
</div>

<canvas id="animcanvas"></canvas>

<!-- Module -->
<script src="qrc:/js/backend.js"></script>
<script src="qrc:/js/apps.js"></script>
<script src="qrc:/js/filter.js"></script>
<script src="qrc:/js/modes.js"></script>
<script src="qrc:/js/keyboard.js"></script>
<script src="qrc:/js/dragdrop.js"></script>
<script src="qrc:/js/volume.js"></script>
<script src="qrc:/js/sysmon.js"></script>
<script src="qrc:/js/capture.js"></script>
<script src="qrc:/js/calendar.js"></script>
<script src="qrc:/js/notes.js"></script>
<script src="qrc:/js/starfield.js"></script>
<script src="qrc:/js/music.js"></script>
<script src="qrc:/js/video.js"></script>
<script src="qrc:/js/clock.js"></script>
<script src="qrc:/js/monitor-grid.js"></script>
<script src="qrc:/js/settings.js"></script>
<script src="qrc:/js/ui-dialog.js"></script>
<!-- main.js muss immer zuletzt geladen werden -->
<script src="qrc:/js/main.js"></script>

<!-- DEBUG -->
<div id="debugConsole"></div>

<script src="js/debug.js"></script>

<div id="addAppDialog" class="hidden add-app-dialog">
    <div class="aad-inner">
        <h2>Add Application</h2>
		<label>Name:</label>
        <input id="aad-name" type="text" placeholder="Name of the application" />
        <label>Command to launch:</label>
        <input id="aad-cmd" type="text" placeholder="cmd" />

        <div id="aad-icon" class="icon-picker">Choose Icon…</div>

        <div class="aad-buttons">
            <button id="aad-save">Add</button>
            <button id="aad-cancel">Cancel</button>
        </div>
    </div>
</div>
<div id="bigIconChooser" class="hidden big-icon-chooser">
    <div class="bic-inner">
        <h2>Select Icon</h2>

        <div id="bigIconList" class="bic-grid"></div>

        <button id="bic-close">Cancel</button>
    </div>
</div>
<div id="modeDebugger"></div>

<div id="settingsPanel" class="hidden">
    <h2>Settings</h2>
	
	<label>Preferred file manager:</label>
	<input id="setFileManager" type="text" placeholder="thunar">

    <label>Music folder:</label>
	<div class="row">
		<input id="setMusicRoot" type="text" placeholder="~/Musik" readonly>
		<button id="pickMusicRoot" title="Choose folder">📁</button>
		<button id="reloadMusic" title="Rescan">↻</button>
	</div>
	
	<label>Preferred audio player:</label>
    <input id="setAudioPlayer" type="text" placeholder="vlc">
    
	<label>Video folder:</label>
	<div class="row">
		<input id="setVideoRoot" type="text" placeholder="~/Videos" readonly>
		<button id="pickVideoRoot" title="Choose folder">📁</button>
		<button id="reloadVideo" title="Rescan">↻</button>
	</div>
    
    <label>Preferred video player:</label>
	<input id="setVideoPlayer" type="text" placeholder="vlc">

    <button id="settingsSave">Save</button>
    <button id="settingsClose">Close</button>
</div>

<!--<video autoplay muted loop playsinline id="bg-video">
    <source src="video.mp4" type="video/mp4">
</video>-->

<div id="ui-dialog" class="hidden">
    <div class="ui-dialog-inner">
        <h2 id="ui-dialog-title"></h2>
        <div id="ui-dialog-content"></div>

        <div class="ui-dialog-buttons">
            <button id="ui-dialog-cancel" class="btn">Cancel</button>
            <button id="ui-dialog-ok" class="btn primary">OK</button>
        </div>
    </div>
</div>
</body>
</html>
)HTML";
