function initStarfield() {
    const canvas = document.getElementById("starfield");
    const ctx = canvas.getContext("2d");

    let warpFactor = 0.30; // 1 normal, 20 = richtige Warp-Geschwindigkeit

    function resize() {
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
    }
    resize();
    window.addEventListener("resize", resize);

    const STAR_COUNT = 350;
    const stars = [];

    function resetStar(s) {
        s.x = canvas.width / 2;
        s.y = canvas.height / 2;
        s.z = Math.random() * 0.7 + 0.1;
        s.size = Math.random() * 1.2 + 0.2;
        let angle = Math.random() * Math.PI * 2;
        s.vx = Math.cos(angle);
        s.vy = Math.sin(angle);
    }

    for (let i = 0; i < STAR_COUNT; i++) {
        let s = {};
        resetStar(s);
        stars.push(s);
    }

    function loop() {
        ctx.fillStyle = "rgba(0,0,0,0.4)";
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        for (let s of stars) {

            // Geschwindigkeit abhängig von Tiefe + Warp-Faktor
            let speed = (s.z * 0.5 + 0.2) * warpFactor;

            let oldX = s.x;
            let oldY = s.y;

            s.x += s.vx * speed * 4;
            s.y += s.vy * speed * 4;
            s.z += 0.015 * warpFactor;

            // außerhalb vom Bildschirm → reset
            if (
                s.x < 0 || s.x > canvas.width ||
                s.y < 0 || s.y > canvas.height
            ) {
                resetStar(s);
                continue;
            }

            // Lichtstrahl
            ctx.beginPath();
            ctx.strokeStyle = `rgba(180, 220, 255, ${0.4 + s.z * 0.3})`;
            ctx.lineWidth = s.size;
            ctx.moveTo(oldX, oldY);
            ctx.lineTo(s.x, s.y);
            ctx.stroke();
        }

        requestAnimationFrame(loop);
    }

    // Expose warp control to outside
    window.setWarp = function(factor) {
        warpFactor = factor;
    };

    loop();
}

window.initBackgroundAnim = initStarfield;
