function initKeyboard(backend) {
	
	// =====================================================================
	// 0) GLOBALER TOGGLE CHECK FÜR FUNKTIONSTASTEN
	// =====================================================================

	const modeToggleMap = {
		"F1":  { toggle: () => toggleSystemMonitor() },
		"F2":  { toggle: () => toggleNotes(backend) },
		"F10": { toggle: () => toggleMonitorGrid() },
		"Print":       { toggle: () => toggleCapturePanel() },
		"PrintScreen": { toggle: () => toggleCapturePanel() },
		"PrintScr":    { toggle: () => toggleCapturePanel() }
	};

	document.addEventListener("keydown", e => {
		const entry = modeToggleMap[e.key];
		if (!entry) return;

		e.preventDefault();
		e.stopImmediatePropagation();

		entry.toggle();  // z. B. toggleNotes()

		// WICHTIG: toggleNotes() ruft am Ende setMode("notes") oder setMode("grid")
	}, true);

    // =====================================================================
    // 1) MASTER KEY ROUTER – jedes Event geht zuerst hier durch
    // =====================================================================
    document.addEventListener("keydown", (e) => {
        const mode = window.activeMode || "grid";

        if (window.modeHandlers[mode]) {
            const consumed = window.modeHandlers[mode](e, backend);

            if (consumed === true) {
                e.preventDefault();
                e.stopImmediatePropagation();
                return;
            }
        }
    }, true);



    // =====================================================================
    // 2) GRID NAVIGATION – wird innerhalb des grid-Handlers verwendet
    // =====================================================================
    window.handleGridNavigation = function(e) {

        const items = Array.from(document.querySelectorAll(".app"));
        if (!items.length) return false;

        const grid = document.getElementById("appgrid");
        const styles = window.getComputedStyle(grid);
        const columns = styles.getPropertyValue("grid-template-columns");
        const colCount = columns.split(" ").length;

        let idx = window.getSelectedIndex ? window.getSelectedIndex() : 0;
        let newIdx = idx;

        switch (e.key) {
            case "ArrowRight": newIdx = idx + 1; break;
            case "ArrowLeft":  newIdx = idx - 1; break;
            case "ArrowDown":  newIdx = idx + colCount; break;
            case "ArrowUp":    newIdx = idx - colCount; break;

            case "Enter":
                items[idx].click();
                return true;
        }

        if (newIdx >= 0 && newIdx < items.length) {
            if (window.setSelectedIndex)
                window.setSelectedIndex(newIdx);
        }

        return true;
    };



    // =====================================================================
    // 3) MODE HANDLERS
    // =====================================================================

    // ----------------------------- GRID MODE -----------------------------
    window.modeHandlers.grid = function(e, backend) {

		// ESC → Launcher schließen, aber NUR wenn filterBuffer leer ist
		if (e.key === "Escape") {
			if (typeof filterBuffer !== "undefined" && filterBuffer.length > 0) {
				// Filter.js soll ESC bekommen → nichts tun!
				return false;
			}

			backend.toggleFromJS();
			return true;
		}

		// Screenshot Panel öffnen
		if (["Print", "PrintScreen", "PrintScr"].includes(e.key)) {
			document.dispatchEvent(new Event("toggleCapture"));
			return true;
		}

		// Systemmonitor
		if (e.key === "F1") {
			document.dispatchEvent(new Event("toggleSysmon"));
			return true;
		}

		// Notes
		if (e.key === "F2") {
			document.dispatchEvent(new Event("toggleNotes"));
			return true;
		}

		// Monitor Grid
		if (e.key === "F10") {
			toggleMonitorGrid();
			return true;
		}

		// GRID Navigation
		const navKeys = [
			"ArrowUp", "ArrowDown", "ArrowLeft", "ArrowRight", "Enter"
		];

		if (navKeys.includes(e.key)) {
			return window.handleGridNavigation(e);
		}

		// ❗ WICHTIG:
		// ALLE anderen Tasten (Buchstaben, Backspace usw.)
		// sollen NICHT consumed werden → Filter.js bekommt sie!
		return false; 
	};



    // ----------------------------- NOTES MODE -----------------------------
    window.modeHandlers.notes = function(e, backend) {

		// ESC → Notes schließen
		if (e.key === "Escape") {
			toggleNotes(backend);
			return true;
		}

		// F-Tasten blockieren
		if (e.key.startsWith("F")) {
			return true;
		}

		// ALLES andere NICHT blockieren → Texteditor soll es bekommen!
		return false;
	};



	// ----------------------------- MUSIC MODE -----------------------------
	window.modeHandlers.music = function(e, backend) {

		// ESC → Musikmodus schließen
		if (e.key === "Escape") {
			if (typeof closeMusicMode === "function")
				closeMusicMode();
			return true;
		}

		// Funktionstasten blockieren
		if (e.key.startsWith("F")) {
			return true;
		}

		// Navigationstasten an music.js durchlassen
		const navKeys = ["ArrowUp", "ArrowDown", "ArrowLeft", "ArrowRight", "Enter"];
		if (navKeys.includes(e.key)) {
			return false;
		}

		// ALLE anderen Tasten → Durchlassen für Texteingabe!
		return false;
	};




    // -------------------------- SYSTEM MONITOR MODE -----------------------
    window.modeHandlers.sysmon = function(e) {
        if (e.key === "Escape") {
            toggleSystemMonitor();
            return true;
        }
        return true;
    };



    // --------------------------- CAPTURE PANEL MODE -----------------------
    window.modeHandlers.capture = function(e) {
        if (e.key === "Escape") {
            toggleCapturePanel();
            return true;
        }
        return true;
    };



    // --------------------------- MONITOR GRID MODE ------------------------
    window.modeHandlers.monitor = function(e) {
        if (e.key === "Escape") {
            toggleMonitorGrid();
            return true;
        }
        return true;
    };



    // --------------------------- CALENDAR MODE -----------------------------
    window.modeHandlers.calendar = function(e) {

        if (e.key === "Escape") {
            if (typeof closeCalendar === "function") {
                closeCalendar();
            }
            return true;
        }

        // Kalender soll komplett blockieren
        return true;
    };



    // ---------------- ADD APP DIALOG MODE ----------------
	window.modeHandlers.addApp = function(e) {

		// ESC → schließen
		if (e.key === "Escape") {
			document.getElementById("addAppDialog").classList.add("hidden");
			setActiveMode("grid");
			return true;
		}

		// F-Tasten blockieren
		if (e.key.startsWith("F")) {
			return true;
		}

		// Alles andere durchlassen (für Inputs!!)
		return false;
	};


	// ---------------- ICON CHOOSER MODE ----------------
	window.modeHandlers.iconChooser = function(e) {

		if (e.key === "Escape") {
			document.getElementById("bigIconChooser").classList.add("hidden");
			setActiveMode("addApp");
			return true;
		}

		// F-Tasten blockieren
		if (e.key.startsWith("F")) {
			return true;
		}

		// Eingaben im Dialog erlauben
		return false;
	};
	
	// ---------------- MONITOR ADD URL DIALOG ----------------
	window.modeHandlers.monitorAdd = function(e) {

		// ESC → Dialog schließen
		if (e.key === "Escape") {
			document.getElementById("monitor-add-dialog").classList.add("hidden");
			setActiveMode("monitor");
			return true;
		}

		// Eingabe zulassen → NICHT blockieren
		return false;
	};


}


// --------------------------------------------------------
// EXPORT
// --------------------------------------------------------
window.initKeyboard = initKeyboard;
