//
// calendar.js — angepasst an das globale Modus-System
//

let currentMonth = new Date().getMonth();
let currentYear = new Date().getFullYear();

function initCalendar() {

    const cal = document.getElementById("calendar");
    const datetimeBar = document.getElementById("datetimebar");
    const grid = document.getElementById("appgrid");

    datetimeBar.onclick = () => {

        // Bereits offen → schließen
        if (window.activeMode === "calendar") {
            closeCalendar();
            return;
        }

        // Öffnen
        openCalendar();
    };
}



function openCalendar() {

    setActiveMode("calendar");

    const cal = document.getElementById("calendar");
    const grid = document.getElementById("appgrid");

    buildCalendar(currentYear, currentMonth);

    cal.classList.add("visible");
    grid.style.display = "none";
}



function closeCalendar() {

    const cal = document.getElementById("calendar");
    const grid = document.getElementById("appgrid");

    cal.classList.remove("visible");
    grid.style.display = "grid";

    setActiveMode("grid");
}



function buildCalendar(year, month) {

    const cal = document.getElementById("calendar");
    cal.innerHTML = "";

    const monthName = new Date(year, month)
        .toLocaleString("en-US", { month: "long" });

    const header = document.createElement("div");
    header.className = "cal-header";
    header.innerHTML = `
        <span id="calPrev" style="cursor:pointer">◀</span>
        <span>${monthName} ${year}</span>
        <span id="calNext" style="cursor:pointer">▶</span>
    `;
    cal.appendChild(header);

    const grid = document.createElement("div");
    grid.className = "cal-grid";

    const days = ["Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"];
    days.forEach(d => {
        const e = document.createElement("div");
        e.className = "day-name";
        e.textContent = d;
        grid.appendChild(e);
    });

    let first = new Date(year, month, 1);
    let start = first.getDay();
    if (start === 0) start = 7;

    // Leere Felder vor dem Monat
    for (let i = 1; i < start; i++) {
        grid.appendChild(document.createElement("div"));
    }

    const daysInMonth = new Date(year, month + 1, 0).getDate();
    const today = new Date();

    for (let d = 1; d <= daysInMonth; d++) {
        const cell = document.createElement("div");
        cell.className = "cal-day";
        cell.textContent = d;

        if (
            d === today.getDate() &&
            year === today.getFullYear() &&
            month === today.getMonth()
        ) {
            cell.classList.add("today");
        }

        grid.appendChild(cell);
    }

    cal.appendChild(grid);

    // Navigation
    document.getElementById("calPrev").onclick = () => {
        month--;
        if (month < 0) {
            month = 11;
            year--;
        }
        currentMonth = month;
        currentYear = year;
        buildCalendar(year, month);
    };

    document.getElementById("calNext").onclick = () => {
        month++;
        if (month > 11) {
            month = 0;
            year++;
        }
        currentMonth = month;
        currentYear = year;
        buildCalendar(year, month);
    };
}



// global
window.initCalendar = initCalendar;
window.openCalendar = openCalendar;
window.closeCalendar = closeCalendar;
