function initBackend() {
    return new Promise(resolve => {

        function waitForWebChannel() {
            if (typeof qt === "undefined" || !qt.webChannelTransport) {
                return setTimeout(waitForWebChannel, 100);
            }

            new QWebChannel(qt.webChannelTransport, channel => {
                const backend = channel.objects.backend;

                backend.sendApps.connect(apps => {
                    // global event → Appgrid aktualisieren
                    document.dispatchEvent(new CustomEvent("appsUpdated", { detail: apps }));
                });

                backend.sendVolume.connect(v => {
                    document.dispatchEvent(new CustomEvent("volumeUpdated", { detail: v }));
                });

                backend.recordingStarted.connect(() => {
                    document.dispatchEvent(new Event("recordingStarted"));
                });

                backend.recordingStopped.connect(() => {
                    document.dispatchEvent(new Event("recordingStopped"));
                });
                
                // TODO TESTING
                //backend.monitorAddUrl("https://linux-howto.org");
                
                // ⭐ Wichtig: global verfügbar!
				window.backend = backend;

                resolve(backend);
            });
        }

        waitForWebChannel();
    });
}

// global verfügbar machen (wichtig für main.js)
window.initBackend = initBackend;
